//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#include <math.h>
#include <vcl\Controls.hpp>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

TColor rgb (int r, int g, int b)
{
        return r | (g<<8) | (b<<16);
}

int x_src1, y_src1, x_src2, y_src2, d, A;
double lambda, rs, eps;

TColor f (int i, int j, int e)
{
        return rgb (i*e, j, 0);
}

int intensite (int x, int y)
{
float d1, d2, a, b, c, xs, ys;
int n;
	a = 0;
	b = 0;
	n = 0;
	for (xs=x_src1-rs; xs<x_src1+rs; xs+=eps)
	for (ys=y_src1-rs; ys<y_src1+rs; ys+=eps)
	{
		if ((xs-x_src1)*(xs-x_src1)+(ys-y_src1)*(ys-y_src1) < rs*rs)
		{
			d1 = sqrt ((x-xs)*(x-xs)+(y-ys)*(y-ys)+d*d);
			a += sin (d1/lambda);
			b += cos (d1/lambda);
			n++;
		}
	}
	for (xs=x_src2-rs; xs<x_src2+rs; xs+=eps)
	for (ys=y_src2-rs; ys<y_src2+rs; ys+=eps)
	{
		if ((xs-x_src2)*(xs-x_src2)+(ys-y_src2)*(ys-y_src2) < rs*rs)
		{
			d1 = sqrt ((x-xs)*(x-xs)+(y-ys)*(y-ys)+d*d);
			a += sin (d1/lambda);
			b += cos (d1/lambda);
			n++;
		}
	}
	a /= n;
	b /= n;
	/* return (a*a + b*b) * 8 * A; */
	c = (a*a + b*b) / 2;
	if (c < 0) c = 0;
	return 15 * (log (c) + 15);
        /*return c * 256;*/
}

int FlagStop;

void __fastcall TForm1::ButtonDrawClick(TObject *Sender)
{
        x_src1 = EditS1X->Text.ToInt();
        y_src1 = EditS1Y->Text.ToInt();
        x_src2 = EditS2X->Text.ToInt();
        y_src2 = EditS2Y->Text.ToInt();
        d = Editd->Text.ToInt();
        lambda = Editlambda->Text.ToDouble();
        rs = Editrs->Text.ToDouble();
        eps = Editeps->Text.ToDouble();
        A = EditA->Text.ToInt();

        TCanvas *canvas = Image->Canvas;
        int height = Image->Height;
        int width = Image->Width;
        /* int e = Edit1->Text.ToInt(); */
        StatusBar->SimpleText = "Computing, please wait...";
        FlagStop = 0;
        for (int i=1; i<width; i++)
        {
                for (int j=1; j<height; j++)
                /*canvas->Pixels[i][j] = f (i, j);*/
                        canvas->Pixels[i][j] = rgb (intensite (i, j), 0, 0);
                Image->Refresh();
                MSG msg;
                if (GetMessage (&msg, NULL, 0, 0))
                {
                        TranslateMessage (&msg);
                        DispatchMessage (&msg);
                }
                if (FlagStop)
                        break;
        }
        StatusBar->SimpleText = "Done.";
}
//---------------------------------------------------------------------------

/*
void __fastcall TForm1::ImageClick(TObject *Sender)
{
        extern PACKAGE TMouse *Mouse;
        int x = Mouse->CursorPos.x - Image->Left;
        int y = Mouse->CursorPos.y - Image->Top;
        Image->Canvas->Pixels[x][y] = rgb (100, 0, 0);
}
*/
//---------------------------------------------------------------------------

void __fastcall TForm1::ImageMouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
        Image->Canvas->Pixels[X][Y] = rgb (100, 0, 0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonStopClick(TObject *Sender)
{
        FlagStop = 1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SaveClick(TObject *Sender)
{
        if (SaveDialog->Execute ())
        {
                Image->Picture->SaveToFile (SaveDialog->FileName);
        }
}
//---------------------------------------------------------------------------

